<?php
namespace User_Registration_Using_Elementor_Form;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Verification_Handler {

	public function __construct() {
		add_action( 'init', [ $this, 'verify_key' ] );
	}

	public function verify_key() {
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Verification links are sent via email and are public; identity is verified via the unique activation key.
		if ( ! isset( $_GET['am_action'], $_GET['key'], $_GET['uid'] ) || 'verify_email' !== $_GET['am_action'] ) {
			return;
		}

		$key     = sanitize_text_field( wp_unslash( $_GET['key'] ) ); // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		$user_id = ( isset( $_GET['uid'] ) ) ? absint( wp_unslash( $_GET['uid'] ) ) : 0; // phpcs:ignore WordPress.Security.NonceVerification.Recommended

		$user = get_user_by( 'ID', $user_id );

		if ( ! $user ) {
			wp_die( esc_html__( 'Invalid user.', 'user-registration-using-elementor-form' ) );
		}

		$meta_key = get_user_meta( $user_id, 'am_activation_key', true );
		$is_verified = get_user_meta( $user_id, 'am_is_verified', true );

		if ( '1' === $is_verified ) {
			wp_die( esc_html__( 'Account already verified. You can login now.', 'user-registration-using-elementor-form' ) );
		}

		if ( $key !== $meta_key ) {
			wp_die( esc_html__( 'Invalid verification key.', 'user-registration-using-elementor-form' ) );
		}


		update_user_meta( $user_id, 'am_is_verified', '1' );
		delete_user_meta( $user_id, 'am_activation_key' );

		// Redirect to login page or home with success message
		$redirect_url = wp_login_url();
		
		// phpcs:ignore WordPress.Security.NonceVerification.Recommended
		if ( ! empty( $_GET['redirect_to'] ) ) {
			// phpcs:ignore WordPress.Security.NonceVerification.Recommended
			$custom_redirect = esc_url_raw( wp_unslash( $_GET['redirect_to'] ) );
			if ( $custom_redirect ) {
				$redirect_url = $custom_redirect;
			}
		}
		
		wp_safe_redirect( add_query_arg( 'verified', '1', $redirect_url ) );
		exit;
	}
}
