<?php
namespace User_Registration_Using_Elementor_Form;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Rest_Api {

	public function __construct() {
		add_action( 'rest_api_init', [ $this, 'register_routes' ] );
	}

	public function register_routes() {
		register_rest_route( 'am-user-reg/v1', '/check-exists', [
			'methods'             => 'POST',
			'callback'            => [ $this, 'check_exists' ],
			'permission_callback' => '__return_true', // Public endpoint
		] );
	}

	public function check_exists( $request ) {
		$field = $request->get_param( 'field' );
		$value = $request->get_param( 'value' );

		if ( empty( $field ) || empty( $value ) ) {
			return new \WP_Error( 'missing_params', 'Missing field or value', [ 'status' => 400 ] );
		}

		$exists = false;
		$message = '';

		if ( 'username' === $field ) {
			if ( username_exists( $value ) ) {
				$exists = true;
				$message = esc_html__( 'Username already exists.', 'user-registration-using-elementor-form' );
			}
		} elseif ( 'email' === $field ) {
			if ( email_exists( $value ) ) {
				$exists = true;
				$message = esc_html__( 'Email already exists.', 'user-registration-using-elementor-form' );
			}
		} elseif ( 'phone' === $field ) {
			$user_query = new \WP_User_Query( [
				'meta_key'     => 'billing_phone', // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_key
				'meta_value'   => $value, // phpcs:ignore WordPress.DB.SlowDBQuery.slow_db_query_meta_value
				'number'       => 1,
				'fields'       => 'ID',
			] );
			if ( ! empty( $user_query->get_results() ) ) {
				$exists = true;
				$message = esc_html__( 'Phone number already exists.', 'user-registration-using-elementor-form' );
			}
		}

		return rest_ensure_response( [
			'exists'  => $exists,
			'message' => $message,
		] );
	}
}
