jQuery(document).ready(function ($) {
  // Debounce function
  function debounce(func, wait, immediate) {
    var timeout;
    return function () {
      var context = this,
        args = arguments;
      var later = function () {
        timeout = null;
        if (!immediate) func.apply(context, args);
      };
      var callNow = immediate && !timeout;
      clearTimeout(timeout);
      timeout = setTimeout(later, wait);
      if (callNow) func.apply(context, args);
    };
  }

  // Check Existence Function (AJAX)
  var checkExistence = debounce(function (element, type) {
    var value = $(element).val();
    var $wrapper = $(element).closest(".elementor-field-group");
    var $error = $wrapper.find(".am-validation-error");

    if (!$error.length) {
      $error = $(
        '<span class="am-validation-error" style="color:#d93025; font-size:11px; display:block; position: absolute; bottom: -18px; left: 10px; white-space: nowrap; z-index: 10;"></span>'
      );
      $wrapper.css('position', 'relative').append($error);
    }

    if (value.length < 3) {
      $error.text("");
      return;
    }

    $.ajax({
      url: amUserReg.restUrl + "check-exists",
      method: "POST",
      data: {
        field: type,
        value: value,
      },
      success: function (response) {
        if (response.exists) {
          $error.text(response.message);
        } else {
          $error.text("");
        }
      },
    });
  }, 500);

  // Password Requirements Check
  function checkPasswordRequirements(element) {
    var password = $(element).val();
    var $wrapper = $(element).closest(".elementor-field-group");
    var $error = $wrapper.find(".am-validation-error");

    if (!$error.length) {
      $error = $('<span class="am-validation-error" style="color:#d93025; font-size:12px; display:block; margin-top:5px; padding: 10px; background: #fff5f5; border: 1px solid #ffc1c1; border-radius: 4px;"></span>');
      $wrapper.append($error);
    }

    var errors = [];
    if (password.length < 8) {
      errors.push("At least 8 characters");
    }
    if (!/[A-Z]/.test(password)) {
      errors.push("One uppercase letter");
    }
    if (!/[^A-Za-z0-9]/.test(password)) {
      errors.push("One special character");
    }

    if (errors.length > 0 && password.length > 0) {
      $error.html("<strong>Password Requirements:</strong><ul style='margin:5px 0 0 15px; padding:0;'><li>" + errors.join("</li><li>") + "</li></ul>").show();
    } else {
      $error.hide();
    }
  }

  // Password Matching Check
  function checkPasswordsMatch(element, passwordFieldId, $form) {
    var confirmPassword = $(element).val();
    var password = $form.find('[name="form_fields['+passwordFieldId+']"], [id="form-field-'+passwordFieldId+'"]').val();
    var $wrapper = $(element).closest(".elementor-field-group");
    var $error = $wrapper.find(".am-validation-error");

    if (!$error.length) {
      $error = $('<span class="am-validation-error" style="color:#d93025; font-size:11px; display:block; position: absolute; bottom: -18px; left: 10px; white-space: nowrap; z-index: 10;"></span>');
      $wrapper.css('position', 'relative').append($error);
    }

    if (confirmPassword !== password && confirmPassword.length > 0) {
      $error.text("Passwords do not match.");
    } else {
      $error.text("");
    }
  }

  // Automatic Field Mapping Initializer
  function initForms() {
    // Look for both the widget container and the form tag itself
    var $forms = $('form[data-am-user-reg-map], [data-am-user-reg-map] form, .elementor-widget-form[data-am-user-reg-map]');

    $forms.each(function(index) {
      var $form = $(this);
      if ($form.is('div')) {
          // If we found the wrapper, drill down to the form
          $form = $form.find('form');
      }
      
      if ($form.hasClass('am-initialized')) return;
      
      // Try to find the map data on the tag or any parent
      var mapData = $form.attr('data-am-user-reg-map') || $form.closest('[data-am-user-reg-map]').attr('data-am-user-reg-map');
      
      if (!mapData) return;
      
      var map;
      try {
        // Handle escaped characters if any
        var decodedData = mapData.replace(/&quot;/g, '"');
        map = JSON.parse(decodedData);
      } catch (e) {
        return;
      }
      
      // Username field
      if (map.username) {
        var $userField = $form.find('[name="form_fields['+map.username+']"], [id="form-field-'+map.username+'"]');
        $userField.on('keyup blur', function() {
          checkExistence(this, 'username');
        });
      }
      
      // Email field
      if (map.email) {
        var $emailField = $form.find('[name="form_fields['+map.email+']"], [id="form-field-'+map.email+'"]');
        console.log("AM User Reg: Mapping email field ID:", map.email, "Found:", $emailField.length);
        $emailField.on('keyup blur', function() {
          checkExistence(this, 'email');
        });
      }
      
      // Phone field
      if (map.billing_phone) {
        var $phoneField = $form.find('[name="form_fields['+map.billing_phone+']"], [id="form-field-'+map.billing_phone+'"]');
        console.log("AM User Reg: Mapping phone field ID:", map.billing_phone, "Found:", $phoneField.length);
        $phoneField.on('keyup blur', function() {
          checkExistence(this, 'phone');
        });
      }

      // Password field
      if (map.password) {
        var $passField = $form.find('[name="form_fields['+map.password+']"], [id="form-field-'+map.password+'"]');
        console.log("AM User Reg: Mapping password field ID:", map.password, "Found:", $passField.length);
        
        $passField.on('focus input blur', function() {
          checkPasswordRequirements(this);
          // Also check match if confirm field exists
          if (map.confirm_password) {
            var $confirmField = $form.find('[name="form_fields['+map.confirm_password+']"], [id="form-field-'+map.confirm_password+'"]');
            if ($confirmField.length) {
              checkPasswordsMatch($confirmField[0], map.password, $form);
            }
          }
        });
        
        // Immediate check if already has value
        if ($passField.val()) {
            checkPasswordRequirements($passField[0]);
        }
      }

      // Confirm Password field
      if (map.confirm_password && map.password) {
        var $confirmField = $form.find('[name="form_fields['+map.confirm_password+']"], [id="form-field-'+map.confirm_password+'"]');
        console.log("AM User Reg: Mapping confirm password field ID:", map.confirm_password, "Found:", $confirmField.length);
        $confirmField.on('input blur', function() {
          checkPasswordsMatch(this, map.password, $form);
        });
      }
      
      $form.addClass('am-initialized');
    });
  }

  // Initial Run
  initForms();

  // Run when Elementor frontend is re-rendered (for AJAX or Editor changes)
  $(window).on('elementor/frontend/init', function() {
      if (elementorFrontend && elementorFrontend.hooks) {
          elementorFrontend.hooks.addAction('frontend/element_ready/form.default', initForms);
      }
  });
  
  // Re-run for dynamic content or just periodic check if needed (Elementor specific)
  // $(document).on('elementor/render/form', initForms);

  // Check for login error parameter and display message
  var urlParams = new URLSearchParams(window.location.search);
  if (urlParams.has('am_error') && urlParams.get('am_error') === 'not_verified') {
      var errorMsg = '<div class="elementor-message elementor-message-danger" role="alert" style="margin-bottom: 20px; padding: 15px; border-left: 5px solid #dc3545; background-color: #fff; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">' +
                       '<strong>' + 'Action Required:' + '</strong> ' + 'Please verify your email before logging in.' +
                     '</div>';
      
      var $loginWidget = $('.elementor-widget-login');
      if ($loginWidget.length) {
          $loginWidget.prepend(errorMsg);
      } else {
          var $loginForm = $('form.login, form#loginform');
          if ($loginForm.length) {
            $loginForm.before(errorMsg);
          } else {
             var $firstSection = $('.elementor-section-wrap').first();
             if ($firstSection.length) {
                 $firstSection.prepend(errorMsg);
             } else {
                 $('body').prepend(errorMsg);
             }
          }
      }
      
      $('html, body').animate({
          scrollTop: 0
      }, 500);
  }
});
